package ru.yandex.calendar.frontend.api.event;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantIsoDateTime;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.LayerIdPredicate;
import ru.yandex.calendar.logic.event.avail.AvailRoutines;
import ru.yandex.calendar.logic.event.avail.AvailabilityInterval;
import ru.yandex.calendar.logic.resource.OfficeManager;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetUserMeetings extends XmlApiActionSupport {

    @Autowired
    private EventRoutines eventRoutines;

    @Autowired
    private SettingsRoutines settingsRoutines;

    @Autowired
    private UserManager userManager;
    @Autowired
    private OfficeManager officeManager;

    @RequestParam
    private Email email;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant from;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant to;

    @Override
    protected XmlWritable doExecute() {
        PassportUid uid = userManager.getUidByEmail(email).getOrThrow("user not found by email " + email);

        final DateTimeZone tz = DateTimeZone.forID(settingsRoutines.getTimeZoneJavaId(uid));
        final Option<Office> office = officeManager.getOfficesByIds(
                settingsRoutines.getSettingsByUid(uid).getYt().filterMap(SettingsYt.getActiveOfficeIdF())).singleO();

        ListF<EventInstanceInfo> events = eventRoutines.getSortedInstancesIMayView(Option.of(uid), from, Option.of(to),
                LayerIdPredicate.allForUser(uid, true), ActionSource.INTERNAL_API);

        ListF<EventInstanceInfo> meetings = events.filter(ei -> ei.getEventWithRelations().getParticipants().isMeeting());

        final ListF<AvailabilityInterval> intervals = meetings.map(AvailabilityInterval.fromEventInstanceInfoF());

        return new XmlWritable() {
            public void write(XmlWriter xw) {
                AvailRoutines.xmlizeAvailability(intervals, tz, office, xw);
            }
        };
    }
}
