package ru.yandex.calendar.frontend.api.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.WebReplyData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author gutman
 */
public class HandleInvitationDecision extends XmlApiActionSupport {

    @Autowired
    private EventWebManager eventWebManager;

    @RequestParam
    private PassportUid uid;
    @RequestParam
    private long eventId;
    @RequestParam
    private Decision decision;

    @RequestParam
    private Option<Long> layerId = Option.empty();
    @RequestParam
    private Option<String> reason = Option.empty();

    @Override
    protected XmlWritable doExecute() {
        ActionInfo actionInfo = getActionInfo();

        WebReplyData reply = new WebReplyData(decision, reason, layerId,
                Option.<Availability>empty(), NotificationsData.useLayerDefaultIfCreate());

        eventWebManager.handleEventInvitationDecision(uid, eventId, reply, actionInfo);
        return XmlWritable.empty();
    }
}
