package ru.yandex.calendar.frontend.api.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.ApiManager;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.LastUpdateManager;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.model.EventUserData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class ShareEventAction extends XmlApiActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(ShareEventAction.class);

    @Autowired
    private UserManager userManager;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private LastUpdateManager lastUpdateManager;
    @Autowired
    private EventWebManager eventWebManager;

    @RequestParam
    private Email email;
    @RequestParam
    private long id;

    @RequestListParam(required = false)
    private ListF<String> notification;
    @RequestParam(required = false)
    private int advanceMins = 15;

    @Override
    protected XmlWritable doExecute() {
        logger.debug("Sharing event " + id + " with user " + email);

        PassportUid uid = userManager.getUidByEmail(email).getOrThrow("unknown user " + email);
        UserInfo user = userManager.getUserInfo(uid);

        ActionInfo actionInfo = getActionInfo();

        EventUserData eventUserData = apiManager.eventUserData(uid, notification, "-" + advanceMins).withIsAttendee(true);

        eventWebManager.attachEvent(user, id, Option.empty(),
                eventUserData.getEventUser(), NotificationsData.createFromWeb(eventUserData.getNotifications()), actionInfo);
        return XmlWritable.empty();
    }

    @Deprecated
    @RequestParam(required = false)
    // for compatibility with moikrug
    public void setLogin(String login) {
        this.email = new Email(login);
    }
}
