package ru.yandex.calendar.frontend.api.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.event.EventAttachedUser;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.dao.MainEventDao;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.EventsLogger;
import ru.yandex.calendar.logic.log.change.EventChangeLogEvents;
import ru.yandex.calendar.logic.log.change.EventChangesJson;
import ru.yandex.calendar.logic.log.change.changes.UserRelatedChangesJson;
import ru.yandex.calendar.logic.sharing.InvitationProcessingMode;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class UnshareEventAction extends XmlApiActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(UnshareEventAction.class);

    @Autowired
    private UserManager userManager;
    @Autowired
    private EventRoutines eventRoutines;
    @Autowired
    private MainEventDao mainEventDao;
    @Autowired
    private EventsLogger eventsLogger;

    @RequestParam
    private Email email;
    @RequestParam
    private long id;

    @Override
    protected XmlWritable doExecute() {
        logger.debug("Unsharing event " + id + ", user " + email);
        PassportUid uid = userManager.getUidByEmail(email).getOrThrow("unknown user " + email);

        ActionInfo actionInfo = getActionInfo();

        String externalId = mainEventDao.findExternalIdsByEventIds(Cf.list(id)).single();

        // XXX: requesting client name, like "mk" or "jira"
        EventAttachedUser detach = eventRoutines.rejectMeeting(id, uid, actionInfo, InvitationProcessingMode.SAVE_ATTACH);

        eventsLogger.log(EventChangeLogEvents.updated(
                ActorId.user(uid), new EventIdLogDataJson(externalId, detach.event),
                EventChangesJson.empty().withUsersAndLayers(UserRelatedChangesJson.find(email, detach))), actionInfo);

        return XmlWritable.empty();
    }

    @Deprecated
    @RequestParam(required = false)
    // for compatibility with moikrug
    public void setLogin(String login) {
        this.email = new Email(login);
    }
}
