package ru.yandex.calendar.frontend.api.event;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantIsoDateTime;
import ru.yandex.calendar.frontend.api.ApiManager;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.calendar.util.dates.DateTimeManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class UpdateEventAction extends XmlApiActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(UpdateEventAction.class);

    @Autowired
    private UserManager userManager;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private EventWebManager eventWebManager;
    @Autowired
    private DateTimeManager dateTimeManager;

    @RequestParam
    private long id;
    @RequestParam
    private String name;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant start;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant end;
    @RequestParam
    private Email email;

    @RequestListParam(required = false)
    private ListF<String> notification;
    @RequestParam(required = false)
    private int advanceMins = 15;

    @RequestParam("place")
    private Option<String> placeO = Option.empty();

    @Override
    protected XmlWritable doExecute() {
        logger.debug("User " + email + " creates event " + name);

        Validate.V.isTrue("start must be before or equal to end, start: " + start + ", end: " + end,
                !start.isAfter(end));

        PassportUid uid = userManager.getUidByEmail(email).getOrThrow("unknown user " + email);

        EventData eventData = eventData(uid);

        ActionInfo actionInfo = getActionInfo();

        eventWebManager.update(userManager.getUserInfo(uid), eventData, true, actionInfo);

        return XmlWritable.empty();
    }

    private EventData eventData(PassportUid uid) {
        EventData eventData = new EventData();
        eventData.getEvent().setStartTs(start);
        eventData.getEvent().setEndTs(end);
        eventData.getEvent().setName(name);
        eventData.getEvent().setIsAllDay(false);
        eventData.getEvent().setId(id);
        eventData.setTimeZone(dateTimeManager.getTimeZoneForUid(uid));

        if (placeO.isPresent()) {
            eventData.getEvent().setLocation(placeO.get());
        }
        eventData.setEventUserData(apiManager.eventUserData(uid, notification, "-" + advanceMins));
        return eventData;
    }

    @Deprecated
    @RequestParam(required = false)
    // for compatibility with moikrug
    public void setLogin(String login) {
        this.email = new Email(login);
    }
}
