package ru.yandex.calendar.frontend.api.ics;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.ics.exp.IcsTodoExporter;
import ru.yandex.calendar.logic.ics.imp.IcsTodoImporter;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsComponent;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsXProperty;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.logic.todo.TodoListEmailManager;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.calendar.util.idlent.YandexUser;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author gutman
 */
public class IcsApiManager {

    @Autowired
    private TodoDao todoDao;
    @Autowired
    private IcsTodoExporter icsTodoExporter;
    @Autowired
    private UserManager userManager;
    @Autowired
    private TodoRoutines todoRoutines;
    @Autowired
    private IcsTodoImporter icsTodoImporter;
    @Autowired
    private TodoListEmailManager todoListEmailManager;

    public void createAndSendTodoListEmails(
            ListIdOrExternalId todoListId, PassportUid uid, ListF<Email> emails,
            Option<Language> language, ActionInfo actionInfo)
    {
        TodoList todoList = todoDao.findNotDeletedTodoListById(todoListId);
        ListF<TodoItem> todoItems = todoDao.findNotDeletedNotArchivedTodoItemsByTodoListIds(
                Cf.list(todoList.getId())).filter(TodoRoutines.isCompletedF().notF());

        IcsCalendar icsCalendar = icsTodoExporter.createCalendarWithTodoItems(uid, todoItems);

        icsCalendar = icsCalendar.addProperty(
                new IcsXProperty(IcsTodoExporter.X_YANDEX_TODO_LIST_TITLE, todoList.getTitle(), Cf.<IcsParameter>list()));
        icsCalendar = icsCalendar.addProperty(
                new IcsXProperty(IcsTodoExporter.X_YANDEX_TODO_LIST_UID, todoList.getExternalId(), Cf.<IcsParameter>list()));

        YandexUser senderUser = userManager.getUserByUid(uid).get();
        MailAddress sender = new MailAddress(senderUser.getEmail().get(), senderUser.getName().getOrElse(""));

        todoListEmailManager.sendTodoListEmails(
                uid, emails, todoList, todoItems, icsCalendar, sender, language, actionInfo);
    }


    public TodoListForIcsImportDescription getTodoListForImportDescription(
            IcsCalendar calendar, boolean deleteOldIfExists)
    {
        if (calendar.hasProperty(IcsTodoExporter.X_YANDEX_TODO_LIST_TITLE)) {
            String title = calendar.getPropertyValue(IcsTodoExporter.X_YANDEX_TODO_LIST_TITLE).get();
            String uid = calendar.getPropertyValue(IcsTodoExporter.X_YANDEX_TODO_LIST_UID).get();

            return TodoListForIcsImportDescription
                    .toSpecificList(calendar.getTodos(), Tuple2.tuple(title, uid), deleteOldIfExists);
        } else {
            return TodoListForIcsImportDescription.toDefaultList(calendar.getTodos());
        }
    }

    public TodoImportResult importCalendarWithTodos(
            IcsCalendar calendar, PassportUid uid, ActionInfo actionInfo, boolean deleteOldIfExists)
    {
        TodoListForIcsImportDescription description = getTodoListForImportDescription(calendar, deleteOldIfExists);
        calendar = new IcsCalendar(Option.<IcsComponent>empty()
                .plus(description.getVtodos()).plus(calendar.getTimezones()));

        if (description.isToSpecificList()) {
            boolean listAlreadyExists = todoDao.findTodoListExistsByExternalIdAndUid(description.getTodoListUid(), uid);
            String listExternalId = description.getTodoListUid();

            TodoImportResult todoImportResult;

            if (listAlreadyExists && !description.getDeleteOldIfExists()) {
                return TodoImportResult.listAlreadyExists();
            }

            long listId;

            if (listAlreadyExists) {
                listId = todoRoutines.getTodoListId(ListIdOrExternalId.externalId(description.getTodoListUid(), uid));

                todoDao.updateTodoItemsSetDeletedByTodoListIds(Cf.list(listId), actionInfo);
                todoDao.updateTodoListTitleAndDescription(listId, description.getTodoListTitle(), "", actionInfo);

                todoImportResult = TodoImportResult.listAlreadyExistsAndOverwritten(listExternalId, listExternalId);
            } else {
                TodoList todoListData = new TodoList();
                todoListData.setTitle(description.getTodoListTitle());
                todoListData.setExternalId(listExternalId);

                listId = todoRoutines.createTodoList(uid, todoListData, actionInfo);
                todoImportResult = TodoImportResult.toNewList(listExternalId);
            }
            icsTodoImporter.importTodos(uid, calendar, actionInfo, listId);

            return todoImportResult;
        } else {
            long listId = todoRoutines.findFirstCreatedListOrCreateNewWithName(
                    uid, calendar.getXWrCalname().getOrElse(TodoRoutines.DEFAULT_LIST_NAME), actionInfo);
            icsTodoImporter.importTodos(uid, calendar, actionInfo, listId);
            return TodoImportResult.toDefaultList();
        }
    }

}
