package ru.yandex.calendar.frontend.api.ics;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVToDo;

/**
 * @author gutman
 */
public class TodoListForIcsImportDescription {

    private final ListF<IcsVToDo> vTodos;
    private final Option<Tuple2<String, String>> todoListTitleAndUid;
    private final boolean deleteOldIfExists;

    private TodoListForIcsImportDescription(
            ListF<IcsVToDo> vTodos, Option<Tuple2<String, String>> todoListTitleAndUid, boolean deleteOldIfExists)
    {
        this.vTodos = vTodos;
        this.todoListTitleAndUid = todoListTitleAndUid;
        this.deleteOldIfExists = deleteOldIfExists;
    }

    public static TodoListForIcsImportDescription toSpecificList(
            ListF<IcsVToDo> vTodos, Tuple2<String, String> todoListTitleAndUid, boolean deleteOldIfExists)
    {
        return new TodoListForIcsImportDescription(vTodos, Option.of(todoListTitleAndUid), deleteOldIfExists);
    }

    public static TodoListForIcsImportDescription toDefaultList(ListF<IcsVToDo> vTodos) {
        return new TodoListForIcsImportDescription(vTodos, Option.<Tuple2<String,String>>empty(), false);
    }

    public boolean isToSpecificList() {
        return todoListTitleAndUid.isPresent();
    }

    public String getTodoListTitle() {
        return todoListTitleAndUid.get()._1;
    }

    public String getTodoListUid() {
        return todoListTitleAndUid.get()._2;
    }

    public ListF<IcsVToDo> getVtodos() {
        return vTodos;
    }

    public boolean getDeleteOldIfExists() {
        return deleteOldIfExists;
    }

}
