package ru.yandex.calendar.frontend.api.inviter;

import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;

@Value
public class CoParticipant {
    PassportUid uid;
    Email email;
    ListF<Meeting> invitationsFrom;
    ListF<Meeting> invitationsTo;
    ListF<Meeting> invitationsCommon;

    public static CoParticipant empty(PassportUid uid, Email email) {
        return new CoParticipant(uid, email, Cf.list(), Cf.list(), Cf.list());
    }

    public static Function2<CoParticipant, CoParticipant, CoParticipant> mergeF() {
        return (f, s) -> {
            Validate.equals(f.getUid(), s.getUid());

            return new CoParticipant(f.getUid(), f.getEmail(),
                    f.getInvitationsFrom().plus(s.getInvitationsFrom()),
                    f.getInvitationsTo().plus(s.getInvitationsTo()),
                    f.getInvitationsCommon().plus(s.getInvitationsCommon()));

        };
    }

    @Value
    public static class Meeting {
        Instant creationTs;
        int attendeesNumber;
    }
}
