package ru.yandex.calendar.frontend.api.inviter;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class CreateMeeting extends InviterActionSupport {

    @Autowired
    private InviterManager inviterManager;

    @RequestParam("uid")
    private PassportUid uid;
    @BindWith(value = JsonBinder.class, required = true)
    private InviterEventData eventData;

    @Override
    protected XmlOrJsonWritable doExecute() {
        final Event created = inviterManager.createMeeting(uid, eventData);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.addTextField("status", "ok");
                w.addNumberField("id", created.getId());
            }
        };
    }
}
