package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantMillis;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class GetUserCoParticipants extends InviterActionSupport {
    @Autowired
    private InviterManager inviterManager;

    @RequestParam
    private PassportUid uid;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> fromTs;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> toTs;
    @RequestParam(required = false)
    private boolean includeAllUsers = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        InstantInterval interval = new InstantInterval(
                fromTs.getOrElse(Instant.now().minus(Duration.standardDays(90))),
                toTs.getOrElse(Instant.now()));

        final ListF<CoParticipant> participants = inviterManager.getUserCoParticipants(uid, interval, includeAllUsers);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {

                w.startArray("users");
                for (CoParticipant p : participants) {
                    w.startObject("user");

                    w.addTextField("uid", p.getUid().getUid());
                    w.addTextField("email", p.getEmail().getEmail());

                    w.startArray("invitations_from");
                    writeMeetings(w, p.getInvitationsFrom());
                    w.endArray();

                    w.startArray("invitations_to");
                    writeMeetings(w, p.getInvitationsTo());
                    w.endArray();

                    w.startArray("invitations_common");
                    writeMeetings(w, p.getInvitationsCommon());
                    w.endArray();

                    w.endObject();
                }
                w.endArray();
            }
        };
    }

    private void writeMeetings(XmlOrJsonWriter w, ListF<CoParticipant.Meeting> meetings) {
        for (CoParticipant.Meeting m : meetings) {
            w.startObject("meeting");

            w.addNumberField("creation_ts", m.getCreationTs().getMillis());
            w.addNumberField("attendees_number", m.getAttendeesNumber());

            w.endObject();
        }
    }
}
