package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantMillis;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class GetUsersBusyIntervals extends InviterActionSupport {

    @Autowired
    private InviterManager inviterManager;

    @RequestParam("uid")
    private ListF<PassportUid> uids;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> fromTs;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> toTs;
    @RequestParam(required = false)
    private boolean includeAbsences = true;

    @Override
    protected XmlOrJsonWritable doExecute() {
        InstantInterval interval = new InstantInterval(
                fromTs.getOrElse(Instant.now()), toTs.getOrElse(Instant.now().plus(Duration.standardDays(3))));

        final ListF<UserBusyIntervals> busyIntervalss = inviterManager.getUsersBusyIntervals(uids, interval, includeAbsences);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startArray("users");

                for (UserBusyIntervals busyIntervals : busyIntervalss) {
                    w.startObject("user");

                    InviterSerializer.writeUserInfoFields(w, busyIntervals.getUser());

                    w.startArray("busy_intervals");
                    for (UserBusyInterval busyInterval : busyIntervals.getIntervals()) {
                        w.startObject("busy_interval");

                        w.addNumberField("start_ts", busyInterval.getStart().getMillis());
                        w.addNumberField("end_ts", busyInterval.getEnd().getMillis());
                        w.addTextField("busyness", busyInterval.getAvailability().toDbValue());

                        if (busyInterval.getResourceInfo().isPresent()) {
                            w.startObject("meeting_resource");

                            ResourceInfo resource = busyInterval.getResourceInfo().get();
                            InviterSerializer.writeResourceInfoMainFields(w, resource);

                            w.endObject();
                        } else {
                            w.addNullField("meeting_resource");
                        }

                        w.endObject();
                    }
                    w.endArray();

                    w.endObject();
                }
                w.endArray();
            }
        };
    }
}
