package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantMillis;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class GetUsersOccupiedResources extends InviterActionSupport {
    @Autowired
    private InviterManager inviterManager;

    @RequestParam("uid")
    private ListF<PassportUid> uids;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> fromTs;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> toTs;

    @Override
    protected XmlOrJsonWritable doExecute() {
        InstantInterval interval = new InstantInterval(
                fromTs.getOrElse(Instant.now().minus(Duration.standardDays(90))),
                toTs.getOrElse(Instant.now()));

        final ListF<UserOccupiedResources> occupiedResourcess = inviterManager.getUsersOccupiedResources(uids, interval);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startArray("users");

                for (UserOccupiedResources occupiedResources : occupiedResourcess) {
                    w.startObject("user");
                    InviterSerializer.writeUserInfoFields(w, occupiedResources.getUser());

                    w.startArray("occupied_resources");
                    for (UserOccupiedResources.OccupiedResource resource : occupiedResources.getResources()) {
                        w.startObject("resource");

                        InviterSerializer.writeResourceInfoMainFields(w, resource.getResourceInfo());

                        w.startArray("meetings_creation_ts");
                        for (Event event : resource.getEvents()) {
                            w.addNumberField("creation_ts", event.getCreationTs().getMillis());
                        }
                        w.endArray();

                        w.endObject();
                    }
                    w.endArray();

                    w.endObject();
                }
                w.endArray();
            }
        };
    }
}
