package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class InviterEventData {
    private Instant startTs;
    private Instant endTs;
    private String name;
    private String description;
    private Option<String> location;
    private ListF<Email> attendees;

    public Event getEvent() {
        Event event = new Event();
        event.setStartTs(startTs);
        event.setEndTs(endTs);
        event.setIsAllDay(false);

        event.setName(name);
        event.setDescription(description);
        event.setLocation(location.getOrElse(""));

        return event;
    }

    public ListF<Email> getAttendees() {
        return attendees;
    }
}
