package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.AbstractEventDataConverter;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.model.EventInvitationsData;
import ru.yandex.calendar.logic.event.model.EventUserData;
import ru.yandex.calendar.logic.sharing.Decision;

/**
 * @author dbrylev
 */
public class InviterEventDataConverter extends AbstractEventDataConverter {

    private final InviterEventData data;

    public InviterEventDataConverter(InviterEventData data, DateTimeZone tz) {
        super(tz);
        this.data = data;
    }

    @Override
    protected EventData doConvert() {
        Event event = data.getEvent();
        EventInvitationsData invitations = new EventInvitationsData(data.getAttendees());

        EventUser user = new EventUser();
        user.setDecision(Decision.YES);
        user.setAvailability(Availability.BUSY);

        EventData eventData = new EventData();

        eventData.setEvent(event);
        eventData.setInvData(invitations);
        eventData.setEventUserData(new EventUserData(user, Cf.list()));
        eventData.setTimeZone(eventTz);

        return eventData;
    }

    public static EventData convert(InviterEventData data, DateTimeZone tz) {
        return new InviterEventDataConverter(data, tz).convert();
    }
}
