package ru.yandex.calendar.frontend.api.inviter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;

/**
 * @author dbrylev
 */
class InviterSerializer {

    public static void writeResourceInfoMainFields(XmlOrJsonWriter w, ResourceInfo resource) {
        w.addNumberField("id", resource.getResourceId());
        w.addTextField("name", resource.getName().getOrElse(""));
        w.addTextField("name_alter", resource.getResource().getAlterName().getOrElse(""));
        w.addTextField("email", resource.getEmail().getEmail());

        w.addNumberField("office_id", resource.getOfficeId());
        w.addTextField("office_abbr", resource.getOffice().getAbbr().getOrElse(""));
        w.addTextField("office_name", resource.getOffice().getName());
        w.addTextField("office_city", resource.getOffice().getCityName().getOrElse(""));
        w.addNumberField("floor_num", resource.getResource().getFloorNum().getOrElse(0));
    }

    public static void writeResourceInfoFields(XmlOrJsonWriter w, ResourceInfo resource) {

        writeResourceInfoMainFields(w, resource);

        w.addNumberField("capacity", resource.getCapacity().getOrElse(0));
        w.addNumberField("seats", resource.getResource().getSeats().getOrElse(0));

        w.addBooleanField("has_phone", resource.getResource().getPhone().isPresent());
        w.addBooleanField("has_voice_conferencing", resource.getResource().getVoiceConferencing());
        w.addBooleanField("has_video", resource.getResource().getVideo().isPresent());

        w.addBooleanField("has_desk", resource.getResource().getDesk());
        w.addBooleanField("has_marker_board", resource.getResource().getMarkerBoard());
        w.addBooleanField("has_lcd_panel", resource.getResource().getLcdPanel() > 0);
        w.addBooleanField("has_projector", resource.getResource().getProjector() > 0);

        w.addTextField("office_tz", resource.getOffice().getTimezoneId().getOrElse(""));
    }

    public static void writeUserInfoFields(XmlOrJsonWriter w, UserInfo user) {
        w.addTextField("uid", user.getSettings().getUid().getUid());
        w.addTextField("email", user.getSettings().getEmail().getEmail());

        Option<Office> tableOffice = user.getTableOffice();

        w.addTextField("table_office_abbr", tableOffice.filterMap(Office.getAbbrF()).getOrElse(""));
        w.addTextField("table_office_name", tableOffice.map(Office.getNameF()).getOrElse(""));
        w.addTextField("table_office_city", tableOffice.filterMap(Office.getCityNameF()).getOrElse(""));
        w.addNumberField("table_floor_num", user.getTableFloorNum().getOrElse(0));
    }
}
