package ru.yandex.calendar.frontend.api.inviter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class ResourceBusyIntervals {
    private final ResourceInfo resourceInfo;
    private final ListF<InstantInterval> intervals;

    public ResourceBusyIntervals(ResourceInfo resourceInfo, ListF<InstantInterval> intervals) {
        this.resourceInfo = resourceInfo;
        this.intervals = intervals;
    }

    public ResourceInfo getResourceInfo() {
        return resourceInfo;
    }

    public ListF<InstantInterval> getIntervals() {
        return intervals;
    }

    public static Function2<ResourceInfo, ListF<InstantInterval>, ResourceBusyIntervals> consF() {
        return new Function2<ResourceInfo, ListF<InstantInterval>, ResourceBusyIntervals>() {
            public ResourceBusyIntervals apply(ResourceInfo r, ListF<InstantInterval> is) {
                return new ResourceBusyIntervals(r, is);
            }
        };
    }
}
