package ru.yandex.calendar.frontend.api.inviter;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.avail.AvailabilityInterval;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public class UserBusyInterval {
    private final InstantInterval interval;
    private final Availability availability;
    private final Option<ResourceInfo> resourceInfo;

    public UserBusyInterval(
            InstantInterval interval, Availability availability, Option<ResourceInfo> resourceInfo)
    {
        this.interval = interval;
        this.availability = availability;
        this.resourceInfo = resourceInfo;
    }

    public static Function<AvailabilityInterval, UserBusyInterval> fromAvailabilityIntervalF(UserInfo user) {
        final Function1B<ResourceInfo> isFromUserOfficeF = ResourceInfo.officeIdF()
                .andThen(user.getLastActivityOffice().map(Office.getIdF()).containsF());

        final Function1B<ResourceInfo> isFromUserCityF = ResourceInfo.officeF().andThen(Office.getCityNameF()
                .andThen(Cf2.isSomeOfF(user.getLastActivityOffice().filterMap(Office.getCityNameF()))));

        return new Function<AvailabilityInterval, UserBusyInterval>() {
            public UserBusyInterval apply(AvailabilityInterval i) {
                Option<ResourceInfo> resource = i.getResources().find(isFromUserOfficeF)
                        .orElse(i.getResources().find(isFromUserCityF));

                return new UserBusyInterval(i.getInterval(), i.getAvailability(), resource);
            }
        };
    }

    public Instant getStart() {
        return getInterval().getStart();
    }

    public Instant getEnd() {
        return getInterval().getEnd();
    }

    public InstantInterval getInterval() {
        return interval;
    }

    public Availability getAvailability() {
        return availability;
    }

    public Option<ResourceInfo> getResourceInfo() {
        return resourceInfo;
    }
}
