package ru.yandex.calendar.frontend.api.inviter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.event.avail.AvailabilityInterval;

/**
 * @author dbrylev
 */
public class UserBusyIntervals {

    private final UserInfo user;
    private final ListF<UserBusyInterval> intervals;

    public UserBusyIntervals(UserInfo user, ListF<UserBusyInterval> intervals) {
        this.user = user;
        this.intervals = intervals;
    }

    public UserInfo getUser() {
        return user;
    }

    public ListF<UserBusyInterval> getIntervals() {
        return intervals;
    }

    public static Function2<UserInfo, ListF<AvailabilityInterval>, UserBusyIntervals> fromAvailabilityIntervalsF() {
        return new Function2<UserInfo, ListF<AvailabilityInterval>, UserBusyIntervals>() {
            public UserBusyIntervals apply(UserInfo u, ListF<AvailabilityInterval> is) {
                return new UserBusyIntervals(u, is.map(UserBusyInterval.fromAvailabilityIntervalF(u)));
            }
        };
    }
}
