package ru.yandex.calendar.frontend.api.inviter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class UserInfo {
    private final Settings settings;
    private final Option<Office> lastActivityOffice;

    private final Option<Office> tableOffice;
    private final Option<Integer> tableFloorNum;

    public UserInfo(Settings settings, Option<Office> lastActivityOffice,
            Option<Office> tableOffice, Option<Integer> tableFloorNum)
    {
        this.settings = settings;
        this.lastActivityOffice = lastActivityOffice;
        this.tableOffice = tableOffice;
        this.tableFloorNum = tableFloorNum;
    }

    public Settings getSettings() {
        return settings;
    }

    public Option<Office> getLastActivityOffice() {
        return lastActivityOffice;
    }

    public Option<Office> getTableOffice() {
        return tableOffice;
    }

    public Option<Integer> getTableFloorNum() {
        return tableFloorNum;
    }

    public static Function<UserInfo, PassportUid> getUidF() {
        return new Function<UserInfo, PassportUid>() {
            public PassportUid apply(UserInfo u) {
                return u.getSettings().getUid();
            }
        };
    }

    public static Function<UserInfo, Option<Office>> getLastActivityOfficeF() {
        return new Function<UserInfo, Option<Office>>() {
            public Option<Office> apply(UserInfo u) {
                return u.getLastActivityOffice();
            }
        };
    }
}
