package ru.yandex.calendar.frontend.api.inviter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.resource.ResourceInfo;

/**
 * @author dbrylev
 */
public class UserOccupiedResources {
    private final UserInfo user;
    private final ListF<OccupiedResource> resources;

    public UserOccupiedResources(UserInfo user, ListF<OccupiedResource> resources) {
        this.user = user;
        this.resources = resources;
    }

    public UserInfo getUser() {
        return user;
    }

    public ListF<OccupiedResource> getResources() {
        return resources;
    }

    public static class OccupiedResource {
        private final ResourceInfo resourceInfo;
        private final ListF<Event> events;

        public OccupiedResource(ResourceInfo resourceInfo, ListF<Event> events) {
            this.resourceInfo = resourceInfo;
            this.events = events;
        }

        public ResourceInfo getResourceInfo() {
            return resourceInfo;
        }

        public ListF<Event> getEvents() {
            return events;
        }
    }
}
