package ru.yandex.calendar.frontend.api.mail;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.frontend.a3.bind.JsonActionResultSerializer;
import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.a3.converters.ConverterToLanguage;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarRequestInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CommandExecutionMonitoringInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.SetAdditionalAttrsInterceptor;
import ru.yandex.calendar.frontend.a3.redirect.RedirectContextA3Configuration;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextA3Configuration;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        A3DefaultContextConfiguration.class,
        WebApiMonitoringConfiguration.class,
        RequestLoggingContextA3Configuration.class,
        RedirectContextA3Configuration.class,
})
public class ApiMailContextA3Configuration {

    @Autowired
    @Qualifier("apiJetty")
    private SingleWarJetty jetty;
    @Autowired
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/api/mail/*", actionApp.createServlet());
    }

    @Bean
    public MailEventActions mailEventActions() {
        return new MailEventActions();
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public ConverterToLanguage converterToLanguage() {
        return new ConverterToLanguage();
    }

    @Bean
    public CalendarRequestInterceptor calendarRequestInterceptor(PassportAuthDomainsHolder domains, TvmManager tvmManager) {
        return new CalendarRequestInterceptor(ActionSource.MAIL, domains, tvmManager);
    }

    @Bean
    public LogActionParametersInterceptor logActionParametersInterceptor() {
        return new LogActionParametersInterceptor();
    }

    @Bean
    public SetAdditionalAttrsInterceptor setAdditionalAttrsInterceptor() {
        return new SetAdditionalAttrsInterceptor();
    }

    @Bean
    public JsonBinder jsonBinder() {
        return new JsonBinder(MailBender.mapper);
    }

    @Bean
    public JsonActionResultSerializer jsonActionResultSerializer() {
        return new JsonActionResultSerializer(MailBender.mapper);
    }

    @Bean
    public DownloadIcsBinder downloadIcsBinder() {
        return new DownloadIcsBinder();
    }

    @Bean
    public CommandExecutionMonitoringInterceptor commandExecutionMonitoringInterceptor() {
        return new CommandExecutionMonitoringInterceptor();
    }
}
