package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.Either;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;

/**
 * @author dbrylev
 */
public class IcsCalendarOrError {
    private final Either<IcsCalendar, String> result;

    private IcsCalendarOrError(Either<IcsCalendar, String> result) {
        this.result = result;
    }

    public static IcsCalendarOrError calendar(IcsCalendar calendar) {
        return new IcsCalendarOrError(Either.<IcsCalendar, String>left(calendar));
    }

    public static IcsCalendarOrError error(String error) {
        return new IcsCalendarOrError(Either.<IcsCalendar, String>right(error));
    }

    public boolean isError() {
        return result.isRight();
    }

    public IcsCalendar getCalendar() {
        return result.getLeft();
    }

    public String getError() {
        return result.getRight();
    }
}
