package ru.yandex.calendar.frontend.api.mail;

import java.util.Optional;

import lombok.Value;
import org.joda.time.DateTimeZone;

import ru.yandex.calendar.logic.event.EventInfo;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;

@Value
public class IcsEvent {
    IcsCalendar ics;
    IcsVEvent vevent;
    Optional<EventInfo> foundEvent;
    EventData converted;
    boolean deleted;

    public DateTimeZone getConvertedTz() {
        return converted.getTimeZone();
    }
}
