package ru.yandex.calendar.frontend.api.mail;

import java.io.StringWriter;
import java.util.Optional;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Try;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.serialize.BenderJsonGeneratorWrapper;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class IncomingIcsMessageInfo {

    @BenderFlatten
    public final XivaReminderSpecificData xiva;

    public final String subject;
    public final String location;
    public final Instant start;
    public final Instant end;

    public final Optional<Type> type;

    public IncomingIcsMessageInfo(
            Optional<XivaReminderSpecificData> xivaData,
            String subject, String location, ListF<ResourceInfo> resources,
            InstantInterval interval, Optional<Type> type, Language lang)
    {
        this.xiva = xivaData.orElseGet(XivaReminderSpecificData::new);

        this.subject = subject;
        this.location = resources.isNotEmpty()
                ? resources.flatMap(ResourceInfo.getNameI18nF(lang)).mkString(", ")
                : location;
        this.start = interval.getStart();
        this.end = interval.getEnd();
        this.type = type;
    }

    public String serializeToJson() {
        StringWriter wr = new StringWriter();

        JsonGenerator gen = Try.tryCatchException(() -> new JsonFactory().createGenerator(wr)).get();
        gen.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);

        MailBender.mapper.serializeJson(this, new BenderJsonGeneratorWrapper(gen));

        return wr.toString();
    }

    public enum Type {
        INVITE,
        UPDATE,
        CANCEL,
    }
}
