package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.calendar.frontend.a3.bind.JsonActionResult;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;

/**
 * @author dbrylev
 */
public abstract class IncomingIcsMessageInfoOrRefusal {

    @JsonActionResult(resultFieldName = "result")
    public static class Info extends IncomingIcsMessageInfoOrRefusal {
        @BenderFlatten
        private final IncomingIcsMessageInfo info;

        public Info(IncomingIcsMessageInfo info) {
            this.info = info;
        }
    }

    @BenderBindAllFields
    @JsonActionResult(resultFieldName = "refusal")
    public static class Refusal extends IncomingIcsMessageInfoOrRefusal {
        private final String reason;

        public Refusal(String reason) {
            this.reason = reason;
        }
    }

    public static Info info(IncomingIcsMessageInfo info) {
        return new Info(info);
    }

    public static Refusal refusal(String reason) {
        return new Refusal(reason);
    }
}
