package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.sharing.Decision;

/**
 * @author Sergey Shinderuk
 */
public enum MailDecision {
    UNDECIDED("undecided"),
    ACCEPTED("accepted"),
    DECLINED("declined"),
    ;

    private static final MapF<String, MailDecision> fromSerializedString = Cf.x(values())
            .toMapMappingToKey(toSerializedStringF());

    private static final MapF<MailDecision, Decision> toDecision = Cf.map(UNDECIDED, Decision.UNDECIDED)
            .plus1(ACCEPTED, Decision.YES)
            .plus1(DECLINED, Decision.NO)
            ;

    private static final MapF<Decision, MailDecision> fromDecision = Cf.map(Decision.UNDECIDED, UNDECIDED)
            .plus1(Decision.YES, ACCEPTED)
            .plus1(Decision.MAYBE, UNDECIDED)
            .plus1(Decision.NO, DECLINED)
            ;


    private final String serializedString;

    private MailDecision(String serializedString) {
        this.serializedString = serializedString;
    }

    public String toSerializedString() {
        return serializedString;
    }

    public static MailDecision fromSerializedString(String string) {
        return fromSerializedString.getOrThrow(string, "unknown decision: ", string);
    }

    public Decision toDecision() {
        return toDecision.getOrThrow(this);
    }

    public static MailDecision fromDecision(Decision decision) {
        return fromDecision.getOrThrow(decision);
    }

    public static Function<MailDecision, String> toSerializedStringF() {
        return new Function<MailDecision, String>() {
            public String apply(MailDecision decision) {
                return decision.toSerializedString();
            }
        };
    }

}
