package ru.yandex.calendar.frontend.api.mail;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class MailEventBaseInfo {
    private final Option<String> name;
    private final Option<String> location;
    private final Option<String> description;
    private final Option<Instant> start;
    private final Option<Instant> end;
    private final Option<Boolean> isAllDay;

    @BenderFlatten
    private final MailRepetitionInfo repetitionInfo;

    private final Option<MailParticipantInfo> organizer;
    @BenderPart(wrapperName = "attendees")
    private final Option<ListF<MailParticipantInfo>> attendees;

    public MailEventBaseInfo(
            Option<String> name, Option<String> location, Option<String> description,
            Option<Instant> start, Option<Instant> end, Option<Boolean> isAllDay, MailRepetitionInfo repetitionInfo,
            Option<MailParticipantInfo> organizer, Option<ListF<MailParticipantInfo>> attendees)
    {
        this.name = name;
        this.location = location;
        this.description = description;
        this.start = start;
        this.end = end;
        this.isAllDay = isAllDay;
        this.repetitionInfo = repetitionInfo;
        this.organizer = organizer;
        this.attendees = attendees;
    }

    public MailEventBaseInfo(
            String name, String location, String description,
            Instant start, Instant end, boolean isAllDay, MailRepetitionInfo repetitionInfo, MailParticipantsInfo participants)
    {
        this(Option.of(name), Option.of(location), Option.of(description),
                Option.of(start), Option.of(end), Option.of(isAllDay), repetitionInfo, participants.getOrganizer(),
                Option.of(participants.getAttendees()));
    }

    public String getName() {
        return name.getOrThrow("name");
    }

    public String getLocation() {
        return location.getOrThrow("location");
    }

    public String getDescription() {
        return description.getOrThrow("description");
    }

    public Instant getStart() {
        return start.getOrThrow("start");
    }

    public Instant getEnd() {
        return end.getOrThrow("end");
    }

    public boolean isAllDay() {
        return isAllDay.getOrThrow("allDay");
    }

    public MailParticipantsInfo getParticipants() {
        return new MailParticipantsInfo(organizer, attendees.getOrThrow("attendees"));
    }

    public MailRepetitionInfo getRepetitionInfo() {
        return repetitionInfo;
    }
}
