package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class MailEventChangesInfo {
    private final MailEventBaseInfo eventAfterChange;
    private final MailEventBaseInfo changedFieldsBeforeChange;

    @BenderPart(wrapperName = "addedAttendees")
    private final Option<ListF<MailParticipantInfo>> addedAttendees;
    @BenderPart(wrapperName = "removedAttendees")
    private final Option<ListF<MailParticipantInfo>> removedAttendees;

    public MailEventChangesInfo(
            MailEventBaseInfo eventAfterChange,
            MailEventBaseInfo changedFieldsBeforeChange,
            ListF<MailParticipantInfo> addedAttendees,
            ListF<MailParticipantInfo> removedAttendees)
    {
        this.eventAfterChange = eventAfterChange;
        this.changedFieldsBeforeChange = changedFieldsBeforeChange;
        this.addedAttendees = Option.when(addedAttendees.isNotEmpty(), addedAttendees);
        this.removedAttendees = Option.when(removedAttendees.isNotEmpty(), removedAttendees);
    }
}
