package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.AbstractEventDataConverter;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.model.EventUserData;

/**
 * @author Sergey Shinderuk
 */
public class MailEventDataConverter extends AbstractEventDataConverter {

    private final String externalId;
    private final MailEventData mailEventData;

    private MailEventDataConverter(String externalId, MailEventData mailEventData) {
        super(mailEventData.getTimeZone());
        this.externalId = externalId;
        this.mailEventData = mailEventData;
    }

    @Override
    protected EventData doConvert() {
        EventData eventData = new EventData();
        eventData.setExternalId(Option.of(externalId));
        eventData.setTimeZone(eventTz);
        eventData.setEvent(mailEventData.getEvent());
        eventData.setEventUserData(new EventUserData(mailEventData.getEventUser(), mailEventData.getNotification()));
        return eventData;
    }

    public static EventData convert(String externalId, MailEventData mailEventData) {
        return new MailEventDataConverter(externalId, mailEventData).convert();
    }
}
