package ru.yandex.calendar.frontend.api.mail;

import lombok.Value;

import ru.yandex.calendar.frontend.a3.bind.JsonActionResult;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * @author dbrylev
 */
public interface MailEventInfoOrRefusal {
    @Value
    @JsonActionResult(resultFieldName = "eventInfo")
    class Info implements MailEventInfoOrRefusal {
        @BenderFlatten
        MailEventInfo info;

        @Override
        public MailEventInfoOrRefusal withSecondsAsMinutesOffsetNotification() {
            return info(info.withSecondsAsMinutesOffsetNotification());
        }
    }

    @Value
    @JsonActionResult(resultFieldName = "refusal")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    class Refusal implements MailEventInfoOrRefusal {
        String reason;
    }

    static Info info(MailEventInfo info) {
        return new Info(info);
    }

    static Refusal refusal(String reason) {
        return new Refusal(reason);
    }

    default MailEventInfoOrRefusal withSecondsAsMinutesOffsetNotification() {
        return this;
    }
}
