package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.SubclassTypeDefinition;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
@BenderParseSubclasses(jsonFieldName = "type", typeDefinition = SubclassTypeDefinition.FIELD, value = {
    MailParticipantInfo.YandexUser.class,
    MailParticipantInfo.Resource.class,
    MailParticipantInfo.ExternalUser.class
})
public abstract class MailParticipantInfo {

    private final String name;
    private final Email email;
    private final MailDecision decision;

    protected MailParticipantInfo(String name, Email email, MailDecision decision) {
        this.name = name;
        this.email = email;
        this.decision = decision;
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class YandexUser extends MailParticipantInfo {
        private final String login;

        public YandexUser(String name, Email email, MailDecision decision, String login) {
            super(name, email, decision);
            this.login = login;
        }
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class Resource extends MailParticipantInfo{
        private final String exchangeName;

        public Resource(String name, Email email, MailDecision decision, String exchangeName) {
            super(name, email, decision);
            this.exchangeName = exchangeName;
        }
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class ExternalUser extends MailParticipantInfo {
        public ExternalUser(String name, Email email, MailDecision decision) {
            super(name, email, decision);
        }
    }

}
