package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MailParticipantsInfo {
    private final Option<MailParticipantInfo> organizer;
    private final ListF<MailParticipantInfo> attendees;

    public static final MailParticipantsInfo EMPTY = new MailParticipantsInfo(Option.<MailParticipantInfo>empty(), Cf.<MailParticipantInfo>list());

    public MailParticipantsInfo(Option<MailParticipantInfo> organizer, ListF<MailParticipantInfo> attendees) {
        this.organizer = organizer;
        this.attendees = attendees;
    }

    public Option<MailParticipantInfo> getOrganizer() {
        return organizer;
    }

    public ListF<MailParticipantInfo> getAttendees() {
        return attendees;
    }
}
