package ru.yandex.calendar.frontend.api.mail;

import java.util.Optional;

import lombok.Value;
import lombok.experimental.Tolerate;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionToStringConverter;
import ru.yandex.calendar.logic.event.repetition.RepetitionUtils;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.rr.FillWithAllArgsConstructor;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Value
@BenderBindAllFields
@FillWithAllArgsConstructor
public class MailRepetitionInfo {
    Optional<String> repetitionDescription;
    Optional<Instant> dueTs;
    Optional<Instant> latestInstanceTs;

    @Tolerate
    public MailRepetitionInfo(RepetitionInstanceInfo info, boolean sinceInsteadDue, Language lang) {
        this.repetitionDescription = RepetitionToStringConverter.tryConvert(info, sinceInsteadDue, lang);
        this.dueTs = info.getRepetition().filterMap(Repetition::getDueTs).toOptional();
        this.latestInstanceTs = RepetitionUtils.calcLatestInstanceEnd(info);
    }

    @Tolerate
    public MailRepetitionInfo(RepetitionInstanceInfo info, Language language) {
        this(info, false, language);
    }

    public static final MailRepetitionInfo EMPTY =
            new MailRepetitionInfo(Optional.empty(), Optional.empty(), Optional.empty());

    public boolean isEmpty() {
        return !repetitionDescription.isPresent();
    }
}
