package ru.yandex.calendar.frontend.api.mail;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.bind.JsonActionResult;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
public abstract class OkResultOrRefusal {

    @BenderBindAllFields
    @JsonActionResult(resultFieldName = "result")
    public static class Ok extends OkResultOrRefusal {
        private final String status = "ok";
    }

    @BenderBindAllFields
    @JsonActionResult(resultFieldName = "refusal")
    public static class Refusal extends OkResultOrRefusal {
        private final String reason;

        public Refusal(String reason) {
            this.reason = reason;
        }
    }

    public static Ok ok() {
        return new Ok();
    }

    public static Refusal refusal(String reason) {
        return new Refusal(reason);
    }

    public Option<String> getRefusalReason() {
        return Option.of(this).filterByType(Refusal.class).map(r -> r.reason);
    }
}
