package ru.yandex.calendar.frontend.api.mail;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class XivaReminderSpecificData {
    public final Option<String> service;
    public final Option<String> operation;

    public final Option<Long> eventId;
    public final Option<String> externalId;
    public final Option<LocalDateTime> instanceStartTs;

    public XivaReminderSpecificData() {
        this.service = Option.empty();
        this.operation = Option.empty();
        this.eventId = Option.empty();
        this.externalId = Option.empty();
        this.instanceStartTs = Option.empty();
    }

    public XivaReminderSpecificData(long eventId, String externalId, Instant instanceStartTs) {
        this.service = Option.of("calendar");
        this.operation = Option.of("meeting-reminder");

        this.eventId = Option.of(eventId);
        this.externalId = Option.of(externalId);
        this.instanceStartTs = Option.of(new LocalDateTime(instanceStartTs, DateTimeZone.UTC));
    }
}
