package ru.yandex.calendar.frontend.api.staff;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;

/**
 * @author dbrylev
 */
public class EventLocation {
    private final Option<ResourceInfo> room;
    private final Option<String> location;

    public EventLocation(Option<ResourceInfo> room, Option<String> location) {
        this.room = room;
        this.location = location;
    }

    public void write(XmlOrJsonWriter w) {
        if (room.isPresent()) {
            w.startObject("room");
            w.addTextField("name", room.get().getNameI18n(Language.RUSSIAN).getOrElse(""));
            w.addTextField("nameEn", room.get().getNameI18n(Language.ENGLISH).getOrElse(""));
            w.addTextField("nameAlt", room.get().getAlterNameI18n(Language.RUSSIAN).getOrElse(""));
            w.addTextField("nameAltEn", room.get().getAlterNameI18n(Language.ENGLISH).getOrElse(""));
            w.endObject();
        }
        if (location.isPresent()) {
            w.addTextField("location", location.get());
        }
    }
}
