package ru.yandex.calendar.frontend.api.staff;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantIsoDateTime;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.event.avail.AvailRoutines;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.avail.AvailabilityInterval;
import ru.yandex.calendar.logic.resource.OfficeManager;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetEventsForStaff extends XmlApiActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(GetEventsForStaff.class);

    @Autowired
    private UserManager userManager;
    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private AvailRoutines availRoutines;
    @Autowired
    private OfficeManager officeManager;

    @RequestParam
    private Email clientEmail;
    @RequestParam
    private Email subjectEmail;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant from;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant to;

    @Override
    protected XmlWritable doExecute() {
        PassportUid subjectUid = userManager.getUidByEmail(subjectEmail).getOrThrow("unknown user " + subjectEmail);
        PassportUid clientUid = userManager.getUidByEmail(clientEmail).getOrThrow("unknown user " + clientEmail);

        final DateTimeZone tz = DateTimeZone.forID(settingsRoutines.getTimeZoneJavaId(clientUid));
        final Option<Office> office = officeManager.getOfficesByIds(
                settingsRoutines.getSettingsByUid(subjectUid).getYt().filterMap(SettingsYt.getActiveOfficeIdF())).singleO();

        final ListF<AvailabilityInterval> subjectBusyIntervals = availRoutines
                .getAvailabilityIntervalsForStaff(clientEmail, subjectEmail, from, to, getActionInfo())
                .withAvailability(Availability.BUSY)
                .unmerged();

        return new XmlWritable() {
            public void write(XmlWriter xw) {
                AvailRoutines.xmlizeAvailability(subjectBusyIntervals, tz, office, xw);
            }
        };
    }
}
