package ru.yandex.calendar.frontend.api.staff;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;

/**
 * @author Daniel Brylev
 *
 * @see ru.yandex.calendar.frontend.kiosk.RoomState
 *
 */
public class RoomState {
    private final String exchangeName;
    private final String state;
    private final Option<Duration> stateDuration;

    private RoomState(String exchangeName, String state, Option<Duration> stateDuration) {
        this.exchangeName = exchangeName;
        this.state = state;
        this.stateDuration = stateDuration;
    }

    public void write(XmlOrJsonWriter w) {
        w.startObject("room");
        w.addTextField("exchange-name", exchangeName);
        w.addTextField("state", state);

        if (stateDuration.isPresent()) {
            w.addTextField("duration-minutes", stateDuration.get().getStandardMinutes() + 1);
        }
        w.endObject();
    }

    public static RoomState free(String exchangeName, Duration freeDuration) {
        return new RoomState(exchangeName, "free", Option.of(freeDuration));
    }

    public static RoomState busy(String exchangeName, Duration busyDuration) {
        return new RoomState(exchangeName, "busy", Option.of(busyDuration));
    }

    public static RoomState notFound(String exchangeName) {
        return new RoomState(exchangeName, "not-found", Option.<Duration>empty());
    }

    public static RoomState notActive(String exchangeName) {
        return new RoomState(exchangeName, "not-active", Option.<Duration>empty());
    }

    public static Function<String, RoomState> notFoundF() {
        return new Function<String, RoomState>() {
            public RoomState apply(String exchangeName) {
                return notFound(exchangeName);
            }
        };
    }

    public static Function<String, RoomState> notActiveF() {
        return new Function<String, RoomState>() {
            public RoomState apply(String exchangeName) {
                return notActive(exchangeName);
            }
        };
    }

    public String getExchangeName() {
        return exchangeName;
    }

    public static Function<RoomState, String> getExchangeNameF() {
        return new Function<RoomState, String>() {
            public String apply(RoomState s) {
                return s.getExchangeName();
            }
        };
    }
}
