package ru.yandex.calendar.frontend.api.staff;

import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class UserFreeBusyState {

    private final Email email;
    private final String state;
    private final Option<DateTime> until;
    private final Option<EventLocation> location;

    public UserFreeBusyState(
            Email email, String state, Option<DateTime> until, Option<EventLocation> location)
    {
        this.email = email;
        this.state = state;
        this.until = until;
        this.location = location;
    }

    public void write(XmlOrJsonWriter w) {
        w.startObject("user");

        w.addTextField("email", email.getEmail());
        w.addTextField("state", state);

        if (until.isPresent()) {
            w.addTextField("until", ISODateTimeFormat.dateTime().print(until.get()));
        }
        if (location.isPresent()) {
            location.get().write(w);
        }
        w.endObject();
    }

    public static UserFreeBusyState free(Email email) {
        return new UserFreeBusyState(email, "free", Option.<DateTime>empty(), Option.<EventLocation>empty());
    }

    public static UserFreeBusyState busy(Email email, DateTime until, EventLocation location) {
        return new UserFreeBusyState(email, "busy", Option.of(until), Option.of(location));
    }

    public static UserFreeBusyState unknown(Email email) {
        return new UserFreeBusyState(email, "unknown", Option.<DateTime>empty(), Option.<EventLocation>empty());
    }

    public static Function<Email, UserFreeBusyState> unknownF() {
        return new Function<Email, UserFreeBusyState>() {
            public UserFreeBusyState apply(Email e) {
                return unknown(e);
            }
        };
    }
}
