package ru.yandex.calendar.frontend.api.todo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.calendar.logic.todo.id.TodoIdOrExternalId;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.lang.Validate;

/**
 * @author gutman
 */
public abstract class ApiActionWithIdOrExternalId extends ApiTodoUserAction {

    @RequestParam(ignoreEmpty = true)
    private Option<String> todoId = Option.empty();
    @RequestParam(ignoreEmpty = true)
    private Option<String> todoExternalId = Option.empty();

    @RequestParam(ignoreEmpty = true)
    private Option<String> listId = Option.empty();
    @RequestParam(ignoreEmpty = true)
    private Option<String> listExternalId = Option.empty();

    @RequestListParam(required = false)
    private ListF<String> todoIds = Cf.list();
    @RequestListParam(required = false)
    private ListF<String> todoExternalIds = Cf.list();

    protected TodoIdOrExternalId getTodoIdOrExternalId() {
        if (todoId.isPresent()) {
            Validate.none(todoExternalId);
            return parseIdOrExternalId(todoId.get()).fold(TodoIdOrExternalId.idF(), TodoIdOrExternalId.externalIdF());
        } else if (todoExternalId.isPresent()) {
            return TodoIdOrExternalId.externalId(todoExternalId.get());
        } else {
            throw new IllegalArgumentException("Define either todo-id or todo-external-id");
        }
    }

    protected ListIdOrExternalId getListIdOrExternalId() {
        if (listId.isPresent()) {
            Validate.none(listExternalId);
            return parseIdOrExternalId(listId.get()).fold(ListIdOrExternalId.idF(), ListIdOrExternalId.externalIdF(getUid()));
        } else if (listExternalId.isPresent()) {
            return ListIdOrExternalId.externalId(listExternalId.get(), getUid());
        } else {
            throw new IllegalArgumentException("Define either list-id or list-external-id");
        }
    }

    protected Option<ListIdOrExternalId> getListIdOrExternalIdO() {
        if (listId.isPresent() || listExternalId.isPresent()) {
            return Option.of(getListIdOrExternalId());
        } else {
            return Option.empty();
        }
    }

    protected Option<TodoIdOrExternalId> getTodoIdOrExternalIdO() {
        if (todoId.isPresent() || todoExternalId.isPresent()) {
            return Option.of(getTodoIdOrExternalId());
        } else {
            return Option.empty();
        }
    }

    protected ListF<TodoIdOrExternalId> getTodoIdOrExternalIds() {
        // hack for Symbian mobile client
        Tuple2List<String, Option<Long>> parsed = todoIds.zipWith(Cf.Long.parseSafeF());

        ListF<Long> ids = Cf2.flatBy2(parsed).get2();
        ListF<String> externalIds = todoExternalIds.plus(parsed.filterBy2Not(Option::isPresent).get1());

        return ids.map(TodoIdOrExternalId.idF()).plus(externalIds.map(TodoIdOrExternalId.externalIdF()));
    }

    // hack for Symbian mobile client
    private Either<Long, String> parseIdOrExternalId(String idStr) {
        Option<Long> parsed = Cf.Long.parseSafe(idStr);
        return parsed.isPresent() ? Either.<Long, String>left(parsed.get()) : Either.<Long, String>right(idStr);
    }
}
