package ru.yandex.calendar.frontend.api.todo;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.frontend.api.ics.IcsApiManager;

/**
 * @author dbrylev
 */
@Configuration
public class ApiTodoContextConfiguration {

    @Bean
    public IcsApiManager icsApiManager() {
        return new IcsApiManager();
    }

    @Bean
    public CreateConflictingTodoItemAction createConflictingTodoItemAction() {
        return new CreateConflictingTodoItemAction();
    }

    @Bean
    public CreateTodoItemAction createTodoItemAction() {
        return new CreateTodoItemAction();
    }

    @Bean
    public CreateTodoListAction createTodoListAction() {
        return new CreateTodoListAction();
    }

    @Bean
    public DeleteTodoItemsAction deleteTodoItemsAction() {
        return new DeleteTodoItemsAction();
    }

    @Bean
    public DeleteTodoListAction deleteTodoListAction() {
        return new DeleteTodoListAction();
    }

    @Bean
    public EmailTodoListAction emailTodoListAction() {
        return new EmailTodoListAction();
    }

    @Bean
    public GetAllTodoListsAndTodoItemsAction getAllTodoListsAndTodoItemsAction() {
        return new GetAllTodoListsAndTodoItemsAction();
    }

    @Bean
    public GetCompletedTodosAction getCompletedTodosAction() {
        return new GetCompletedTodosAction();
    }

    @Bean
    public GetCompletedTodosGroupedByCompletionTsAction getCompletedTodosGroupedByCompletionTsAction() {
        return new GetCompletedTodosGroupedByCompletionTsAction();
    }

    @Bean
    public GetTodoItemAction getTodoItemAction() {
        return new GetTodoItemAction();
    }

    @Bean
    public GetTodoItemsAction getTodoItemsAction() {
        return new GetTodoItemsAction();
    }

    @Bean
    public GetTodoListAction getTodoListAction() {
        return new GetTodoListAction();
    }

    @Bean
    public GetTodoListColorsAction getTodoListColorsAction() {
        return new GetTodoListColorsAction();
    }

    @Bean
    public GetTodoListsAction getTodoListsAction() {
        return new GetTodoListsAction();
    }

    @Bean
    public GetTodoTimestampAction getTodoTimestampAction() {
        return new GetTodoTimestampAction();
    }

    @Bean
    public GetTodoWebSettingsAction getTodoWebSettingsAction() {
        return new GetTodoWebSettingsAction();
    }

    @Bean
    public GetTodoSidebarAction getTodoSidebarAction() {
        return new GetTodoSidebarAction();
    }

    @Bean
    public ImportCalendarWithTodosByIcsUrlAction importCalendarWithTodosByIcsUrlAction() {
        return new ImportCalendarWithTodosByIcsUrlAction();
    }

    @Bean
    public RestoreTodoItemsAction restoreTodoItemsAction() {
        return new RestoreTodoItemsAction();
    }

    @Bean
    public RestoreTodoListAction restoreTodoListAction() {
        return new RestoreTodoListAction();
    }

    @Bean
    public ReorderTodoItemsAction reorderTodoItemsAction() {
        return new ReorderTodoItemsAction();
    }

    @Bean
    public SetTodoItemsCompletedAction setTodoItemsCompletedAction() {
        return new SetTodoItemsCompletedAction();
    }

    @Bean
    public SetTodoWebSettingsAction setTodoWebSettingsAction() {
        return new SetTodoWebSettingsAction();
    }

    @Bean
    public UpdateTodoItemAction updateTodoItemAction() {
        return new UpdateTodoItemAction();
    }

    @Bean
    public UpdateTodoListAction updateTodoListAction() {
        return new UpdateTodoListAction();
    }
}
