package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantUnixtime;
import ru.yandex.calendar.frontend.a3.converters.ConverterToIntColor;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class CreateConflictingTodoItemAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {
    private static final Logger logger = LoggerFactory.getLogger(CreateConflictingTodoItemAction.class);

    @Autowired
    private TodoRoutines todoRoutines;
    @Autowired
    private TodoDao todoDao;

    @RequestParam
    private Option<String> title;

    @RequestParam(customConverter = ConverterToInstantUnixtime.class)
    private Option<Instant> dueTs;
    @RequestParam(customConverter = ConverterToIntColor.class, ignoreEmpty = true)
    private Option<Integer> color;

    @RequestParam(required = false)
    private boolean archived = false;
    @RequestParam(required = false)
    private boolean completed = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        TodoItem todo = new TodoItem();
        // XXX upyachka XXX
        // mobile client will not resolve conflicts
        // or treat conflicts specially
        // let's mark conflict with prefix in title
        todo.setTitle("[конфликт] " + title.getOrElse(TodoUtils.getDefaultItemName(getLanguage())));

        Option<ListIdOrExternalId> listId = getListIdOrExternalIdO();
        Option<Long> todoListId = todoDao.findNotDeletedTodoListIdById(listId.get());

        if (listId.isPresent() && !todoListId.isPresent()) {
            logger.info("Todo list " + listId.get() + " already deleted, creating conflicting todo in default list");
            todo.setTodoListId(findFirstUserCreatedTodoListOrCreateNew());

        } else if (!todoListId.isPresent()) {
            todo.setTodoListId(findFirstUserCreatedTodoListOrCreateNew());

        } else {
            todo.setTodoListId(todoListId.get());
        }
        todo.setColor(color);
        todo.setDueTs(dueTs);
        todo.setCreationTs(new Instant());

        todo.setArchived(archived);
        if (completed) {
            todo.setCompletionTs(getActionInfo().getNow());
        }

        long id = todoRoutines.checkPermissionsAndCreateTodoItem(getUid(), todo, getActionInfo());

        return XmlOrJsonWritable.textField("todo-item-id", id);
    }
}
