package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToIntColor;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author gutman
 */
public class CreateTodoListAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam
    private Option<String> title;
    @RequestParam(required = false)
    private String description = "";
    @RequestParam(customConverter = ConverterToIntColor.class)
    private Option<Integer> color = Option.empty();

    @Override
    protected XmlOrJsonWritable doExecute() {
        TodoList list = new TodoList();

        list.setDescription(description);
        list.setTitle(title.getOrElse(TodoUtils.getDefaultListName(getLanguage())));
        list.setCreationTs(new Instant());
        list.setCreatorUid(getUid());
        list.setColor(color);

        Option<ListIdOrExternalId> listIdOrExternalId = getListIdOrExternalIdO();
        if (listIdOrExternalId.isPresent()) {
            list.setExternalId(listIdOrExternalId.get().getExternalId());
        }
        long id = todoRoutines.createTodoList(getUid(), list, getActionInfo());

        return XmlOrJsonWritable.textFields(
                "todo-list-id", Long.toString(id),
                "creation-ts", Long.toString(getActionInfo().getNow().getMillis() / 1000));
    }
}
