package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.TodoIdOrExternalId;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author gutman
 */
public class DeleteTodoItemsAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam(required = false)
    private boolean toArchive = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        ListF<TodoIdOrExternalId> todoItemIds = getTodoIdOrExternalIds();

        if (toArchive) {
            todoRoutines.archiveTodoItemsByIds(getUid(), todoItemIds, getActionInfo());
        } else {
            todoRoutines.deleteTodoItemsByIds(getUid(), todoItemIds, getActionInfo());
        }

        String deletedIds = todoItemIds.map(TodoIdOrExternalId.todoIdOrExternalIdStringF()).mkString(",");

        return XmlOrJsonWritable.textField("deleted-todo-item-ids", deletedIds);
    }
}
