package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.a3.interceptors.ActionWithLockAndTransaction;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;

/**
 * @author gutman
 */
public class DeleteTodoListAction extends ApiActionWithIdOrExternalId implements ActionWithLockAndTransaction {

    @Autowired
    private TodoRoutines todoRoutines;

    @Override
    protected XmlOrJsonWritable doExecute() {
        ListIdOrExternalId idOrExternalId = getListIdOrExternalId();
        todoRoutines.deleteTodoListSafe(getUid(), idOrExternalId, getActionInfo());

        return XmlOrJsonWritable.textField("deleted-todo-list-id", idOrExternalId.toIdOrExternalIdString());
    }

}
