package ru.yandex.calendar.frontend.api.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.frontend.api.ics.IcsApiManager;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.misc.email.Email;

/**
 * @author gutman
 */
public class EmailTodoListAction extends ApiActionWithIdOrExternalId {

    @Autowired
    private TodoRoutines todoRoutines;
    @Autowired
    private IcsApiManager icsApiManager;

    @RequestListParam
    private ListF<Email> emails;

    @Override
    protected XmlOrJsonWritable doExecute() {
        todoRoutines.ensureTodoListExistsByUidAndListId(getUid(), getListIdOrExternalId());

        icsApiManager.createAndSendTodoListEmails(
                getListIdOrExternalId(), getUid(), emails, getLanguage(), getActionInfo());

        return XmlOrJsonWritable.empty();
    }
}
