package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetCompletedTodosAction extends ApiTodoUserAction {

    @Autowired
    private TodoDao todoDao;

    @RequestParam("page")
    private Option<Integer> pageNumberO = Option.empty();

    private static final int TODOS_PER_PAGE = 20;

    @RequestParam("skip")
    private Option<Integer> skipO = Option.empty();
    @RequestParam("count")
    private Option<Integer> countO = Option.empty();

    @Override
    protected XmlOrJsonWritable doExecute() {
        final int pagetNumber = pageNumberO.getOrElse(0);
        final int limit = countO.getOrElse(TODOS_PER_PAGE);
        final int offset = skipO.getOrElse(pagetNumber * limit);

        final ListF<TodoItem> todoItems = todoDao.findNotDeletedCompletedTodosByCreatorUid(getUid(), offset, limit);
        final int archivedTodoItemsCount = todoDao.findNotDeletedCompletedTodosCount(getUid());

        final DateTimeZone userTz = getUserTz();

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.addTextField("total-pages", (int) Math.ceil((double) archivedTodoItemsCount / TODOS_PER_PAGE));
                w.addTextField("page", pagetNumber);

                w.startArray("todo-items");
                for (TodoItem todo : todoItems) {
                    TodoSerializer.serializeTodoItem(w, todo, getOutputMode(), userTz);
                }
                w.endArray();
            }
        };
    }
}
