package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.beans.generated.TodoItemFields;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetCompletedTodosGroupedByCompletionTsAction extends ApiTodoUserAction {

    @Autowired
    private TodoDao todoDao;

    @Override
    protected XmlOrJsonWritable doExecute() {
        final ListF<TodoItem> todoItems = todoDao.findNotDeletedCompletedTodosByCreatorUid(getUid());

        final DateTimeZone userTz = getUserTz();

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startObject("todo-items");
                TodoSerializer.serializeTodoItemsGroupedByMonthAndDay(w, todoItems, userTz, getOutputMode(),
                        TodoItemFields.COMPLETION_TS.getF().<TodoItem, Instant>uncheckedCast());
                w.endObject();
            }
        };
    }

}
