package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetTodoItemAction extends ApiActionWithIdOrExternalId {

    @Autowired
    private TodoDao todoDao;
    @Autowired
    private TodoRoutines todoRoutines;

    @Override
    protected XmlOrJsonWritable doExecute() {
        final TodoItem todo = todoDao.findNotDeletedNotArchivedTodoItemById(
                getTodoIdOrExternalId(), getUid());

        todoRoutines.ensureTodoListExistsByUidAndListId(getUid(), ListIdOrExternalId.id(todo.getTodoListId()));

        final DateTimeZone userTz = getUserTz();

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                TodoSerializer.serializeTodoItem(w, todo, getOutputMode(), userTz);
            }
        };
    }

}
