package ru.yandex.calendar.frontend.api.todo;

import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.todo.TodoDao;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author gutman
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetTodoListAction extends ApiActionWithIdOrExternalId {

    @Autowired
    private TodoDao todoDao;
    @Autowired
    private TodoRoutines todoRoutines;

    @RequestParam(required = false)
    private boolean onlyNotCompleted = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        todoRoutines.ensureTodoListExistsByUidAndListId(getUid(), getListIdOrExternalId());

        Option<Long> defaultListId = findFirstUserCreatedTodoListOrCreateNewIfNotMaya();
        final TodoList todoList = todoDao.findNotDeletedTodoListById(getListIdOrExternalId());

        final ListF<TodoItem> todoItems;
        if (onlyNotCompleted) {
            todoItems = todoDao
                    .findNotDeletedNotArchivedNotCompletedTodoItemsByTodoListIds(Cf.list(todoList.getId()));
        } else {
            todoItems = todoDao
                    .findNotDeletedNotArchivedTodoItemsByTodoListIds(Cf.list(todoList.getId()));
        }

        final DateTimeZone userTz = getUserTz();

        // XXX: sorting, filtering, paging

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startObject("todo-list");

                TodoSerializer.serializeTodoListFields(w, todoList, defaultListId.isSome(todoList.getId()));

                w.startArray("todo-items");
                for (TodoItem todo : todoItems) {
                    TodoSerializer.serializeTodoItem(w, todo, getOutputMode(), userTz);
                }
                w.endArray();

                w.endObject();
            }
        };
    }
}
